/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.block;

import gloridifice.watersource.registry.BlockRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CoconutBlock
extends Block
implements IGrowable {
    public static final EnumProperty GROUND_TYPE = EnumProperty.func_177709_a((String)"groundtype", GroundType.class);
    public static final VoxelShape ORDINARY_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final VoxelShape GROWING_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);

    public CoconutBlock(AbstractBlock.Properties properties, String name) {
        super(properties);
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)GROUND_TYPE, (Comparable)((Object)GroundType.ORDINARY)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        GroundType type = GroundType.ORDINARY;
        Block block = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_177230_c();
        if (!context.func_195999_j().func_225608_bj_()) {
            if (Blocks.field_150354_m == block) {
                type = GroundType.SAND;
            } else if (Blocks.field_196611_F == block) {
                type = GroundType.RED_SAND;
            }
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)GROUND_TYPE, (Comparable)((Object)type));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (pos.func_177977_b().equals((Object)fromPos)) {
            if (worldIn.func_180495_p(fromPos).func_177230_c() == Blocks.field_150354_m) {
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)GROUND_TYPE, (Comparable)((Object)GroundType.SAND)));
            }
            if (worldIn.func_180495_p(fromPos).func_177230_c() == Blocks.field_196611_F) {
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)GROUND_TYPE, (Comparable)((Object)GroundType.RED_SAND)));
            }
            if (worldIn.func_180495_p(fromPos).func_196958_f()) {
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)GROUND_TYPE, (Comparable)((Object)GroundType.ORDINARY)));
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{GROUND_TYPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b((Property)GROUND_TYPE) == GroundType.ORDINARY ? ORDINARY_SHAPE : GROWING_SHAPE;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return state.func_177229_b((Property)GROUND_TYPE) != GroundType.ORDINARY;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.7;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (this.func_176473_a((IBlockReader)worldIn, pos, state, false)) {
            worldIn.func_175656_a(pos, BlockRegistry.BLOCK_COCONUT_SAPLING.func_176223_P());
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
            this.func_225535_a_(worldIn, rand, pos, state);
        }
    }

    public static enum GroundType implements IStringSerializable
    {
        ORDINARY("ordinary"),
        SAND("sand"),
        RED_SAND("redsand");

        private final String name;

        private GroundType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

